<?php
// api/coins_tx_list.php
declare(strict_types=1);
require_once __DIR__ . '/bootstrap.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: Authorization, Content-Type, Accept');
header('Access-Control-Allow-Methods: GET, OPTIONS');
if (($_SERVER['REQUEST_METHOD'] ?? '') === 'OPTIONS') { http_response_code(204); exit; }

function ok($d=[], $c=200){ http_response_code($c); echo json_encode(['ok'=>true]+$d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }
function bad($m,$c=400){ http_response_code($c); echo json_encode(['ok'=>false,'error'=>$m], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

$pdo = function_exists('db') ? db() : null;
if (!$pdo) bad('DB connection unavailable', 500);

// المصادقة — نفس أسلوب coins_get.php
$user = auth_required();
$uid = null; $id = null;
if (is_array($user)) {
  $uid = $user['uid'] ?? null;
  $id  = $user['id']  ?? ($user['userid'] ?? null);
} else {
  if (is_string($user) && ctype_digit($user)) $id = (int)$user;
  elseif (is_numeric($user)) $id = (int)$user;
  else $uid = (string)$user;
}

$limit = max(1, min((int)($_GET['limit'] ?? 200), 500));

// نحاول دعم حقول وأسامي شائعة
// coins_ledger: id, user_id أو uid, amount أو delta, memo/note, created_at/ts
if ($uid) {
  $st = $pdo->prepare("
    SELECT
      id,
      COALESCE(amount, delta, 0) AS amount,
      COALESCE(memo, note, '') AS memo,
      COALESCE(created_at, ts, NOW()) AS created_at
    FROM coins_ledger
    WHERE (uid = :uid OR user_uid = :uid)
    ORDER BY id DESC
    LIMIT :lim
  ");
  $st->bindValue(':uid', $uid);
  $st->bindValue(':lim', $limit, PDO::PARAM_INT);
} else {
  $st = $pdo->prepare("
    SELECT
      id,
      COALESCE(amount, delta, 0) AS amount,
      COALESCE(memo, note, '') AS memo,
      COALESCE(created_at, ts, NOW()) AS created_at
    FROM coins_ledger
    WHERE (user_id = :id OR userid = :id)
    ORDER BY id DESC
    LIMIT :lim
  ");
  $st->bindValue(':id', (int)$id, PDO::PARAM_INT);
  $st->bindValue(':lim', $limit, PDO::PARAM_INT);
}

$st->execute();
$rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

$out = [];
foreach ($rows as $r) {
  $amount = (int)($r['amount'] ?? 0); // موجب/سالب
  $out[] = [
    'id'         => (int)($r['id'] ?? 0),
    'amount'     => $amount,
    'memo'       => (string)($r['memo'] ?? ''),
    'created_at' => (string)($r['created_at'] ?? ''),
  ];
}

ok(['transactions' => $out]);
