<?php
// _common.php
require_once __DIR__ . '/bootstrap.php'; // لو عندك ملف تهيئة مختلف عدّل المسار

header('Content-Type: application/json; charset=utf-8');

/** يرجّع id المستخدم الحالي من التوكن/الجلسة */
function me_id(PDO $db) {
  // استبدل هذا بما عندك لاستخراج هوية المستخدم من الـ token
  if (!isset($GLOBALS['AUTH_USER_ID'])) {
    // مثال: لو خزّنت الـ id بعد التحقق
    // $GLOBALS['AUTH_USER_ID'] =  (int) $_SESSION['uid'] ?? 0;
  }
  return (int)($GLOBALS['AUTH_USER_ID'] ?? 0);
}

/** يحاول تحويل أي قيمة peer إلى users.id (رقمي) بقبول id أو userid */
function resolve_user_id(PDO $db, $raw) {
  if ($raw === null) return 0;
  $s = trim((string)$raw);
  if ($s === '') return 0;

  // جرّب كـ users.id
  if (ctype_digit($s)) {
    $q = $db->prepare('SELECT id FROM users WHERE id = ? LIMIT 1');
    $q->execute([$s]);
    $id = $q->fetchColumn();
    if ($id) return (int)$id;
  }

  // جرّب كـ users.userid (الكود العام الذي يظهر للمستخدم)
  $q = $db->prepare('SELECT id FROM users WHERE userid = ? LIMIT 1');
  $q->execute([$s]);
  $id = $q->fetchColumn();
  if ($id) return (int)$id;

  // (اختياري) لو عندك عمود آخر مثل uid/uuid أضِفه هنا
  return 0;
}

/** هل المستخدمان صديقان؟ (صف واحد accepted بأي ترتيب) */
function are_friends(PDO $db, int $a, int $b) {
  $q = $db->prepare("
    SELECT 1
    FROM friends
    WHERE (
      (uid1 = :a AND uid2 = :b) OR
      (uid1 = :b AND uid2 = :a)
    ) AND status = 'accepted'
    LIMIT 1
  ");
  $q->execute([':a' => $a, ':b' => $b]);
  return (bool)$q->fetchColumn();
}

/** يجد thread مشترك (مشاركَيْن) أو 0 إن لم يوجد */
function find_dm_thread(PDO $db, int $a, int $b) {
  $q = $db->prepare("
    SELECT p1.thread_id
    FROM dm_participants p1
    JOIN dm_participants p2 ON p1.thread_id = p2.thread_id
    WHERE p1.user_id = :a AND p2.user_id = :b
    LIMIT 1
  ");
  $q->execute([':a' => $a, ':b' => $b]);
  $id = $q->fetchColumn();
  return $id ? (int)$id : 0;
}
