<?php
// voicechat/agents/web/login.php
declare(strict_types=1);
require_once __DIR__ . '/_web_common.php';

$msg = null; $err = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح. أعد المحاولة.';
  } else {
    $username = trim((string)($_POST['username'] ?? ''));
    $password = (string)($_POST['password'] ?? '');
    if ($username === '' || $password === '') {
      $err = 'من فضلك أدخل اسم المستخدم وكلمة المرور.';
    } else {
      $res = api_call('auth_login.php', 'POST', [
        'username' => $username,
        'password' => $password,
      ]);
      if (($res['ok'] ?? false) && !empty($res['token'])) {
        agent_set_token($res['token'], 12*3600);
        header('Location: dashboard.php'); exit;
      } else {
        $err = 'بيانات الدخول غير صحيحة أو الحساب موقوف.';
      }
    }
  }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>تسجيل دخول الوكلاء</title>
  <style>
    :root{--bg:#0b1220;--panel:#0f172a;--text:#e5e7eb;--border:#243047;--primary:#3b82f6;--danger:#ef4444}
    *{box-sizing:border-box} body{margin:0;background:var(--bg);color:var(--text);font-family:system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,Cantarell,Noto Sans,Tahoma,Arial}
    .wrap{min-height:100dvh;display:grid;place-items:center;padding:24px}
    .card{width:min(520px,95vw);background:var(--panel);border:1px solid var(--border);border-radius:14px;padding:20px}
    h1{margin:0 0 12px} .muted{opacity:.85}
    .form{display:grid;gap:12px;margin-top:8px}
    .input label{display:block;font-size:13px;margin-bottom:6px;opacity:.9}
    .input input{width:100%;padding:10px 12px;border-radius:10px;border:1px solid var(--border);background:#0c1426;color:var(--text)}
    .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid var(--border);background:var(--primary);color:white;text-decoration:none;cursor:pointer}
    .alert{border:1px solid var(--danger);padding:10px 12px;border-radius:10px;background:rgba(239,68,68,.08);margin:8px 0}
    .footer{margin-top:8px;font-size:12px;opacity:.85}
  </style>
</head>
<body>
<div class="wrap">
  <div class="card">
    <h1>بوابة وكلاء الشحن</h1>
    <div class="muted">سجّل الدخول للوصول إلى لوحة الشحن.</div>

    <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
    <?php if ($msg): ?><div class="alert" style="border-color:#22c55e;background:rgba(34,197,94,.08)"><?= e($msg) ?></div><?php endif; ?>

    <form method="post" class="form" autocomplete="username">
      <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
      <div class="input">
        <label>اسم المستخدم</label>
        <input name="username" required autofocus>
      </div>
      <div class="input">
        <label>كلمة المرور</label>
        <input name="password" type="password" required>
      </div>
      <div>
        <button class="btn" type="submit">دخول</button>
      </div>
    </form>

    <div class="footer">© <?= date('Y') ?> — Wesal</div>
  </div>
</div>
</body>
</html>
