<?php
// /public_html/voicechat/agents/charge_user.php
declare(strict_types=1);
require __DIR__ . '/_common.php';

$DEBUG = isset($_GET['dbg']);

try {
  $agent = require_agent();

  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    json_out(['ok'=>false,'error'=>'method_not_allowed'], 405);
  }

  $in = function_exists('json_in') ? json_in() : [];
  $user_uid = trim((string)($in['user_uid'] ?? ''));
  $coins    = (int)($in['coins'] ?? 0);
  $idk_in   = trim((string)($in['idempotency_key'] ?? ''));
  $idk      = $idk_in !== '' ? $idk_in : bin2hex(random_bytes(16));

  if ($user_uid === '' || $coins <= 0) {
    json_out(['ok'=>false,'error'=>'bad_request'], 400);
  }

  $pdo = db();

  // هل المستخدم موجود؟
  $st = $pdo->prepare("SELECT id, uid, coins FROM users WHERE uid=? LIMIT 1");
  $st->execute([$user_uid]);
  $user = $st->fetch();
  if (!$user) {
    $pdo->prepare("INSERT INTO agent_charges (agent_id,user_uid,coins,status,error_code) VALUES (?,?,?,?,?)")
        ->execute([(int)$agent['id'], $user_uid, $coins, 'failed', 'user_not_found']);
    json_out(['ok'=>false,'error'=>'user_not_found'], 404);
  }

  // اكتشاف الأعمدة اختيارياً
  $has_currency = false;
  $has_idk      = false;
  $has_ref_uid  = false;
  try {
    $has_currency = (bool)$pdo->query("SHOW COLUMNS FROM agent_ledger LIKE 'currency'")->fetch();
  } catch (Throwable $e) {}
  try {
    $has_idk = (bool)$pdo->query("SHOW COLUMNS FROM agent_ledger LIKE 'idempotency_key'")->fetch();
  } catch (Throwable $e) {}
  try {
    $has_ref_uid = (bool)$pdo->query("SHOW COLUMNS FROM agent_ledger LIKE 'ref_user_uid'")->fetch();
  } catch (Throwable $e) {}

  $pdo->beginTransaction();

  // اقفل رصيد الوكيل
  $st = $pdo->prepare("SELECT main_balance FROM agents WHERE id=? FOR UPDATE");
  $st->execute([(int)$agent['id']]);
  $row = $st->fetch();
  if (!$row) throw new Exception('agent_not_found');

  $bal_before = (int)$row['main_balance'];
  if ($bal_before < $coins) {
    $pdo->rollBack();
    $pdo->prepare("INSERT INTO agent_charges (agent_id,user_uid,coins,status,error_code) VALUES (?,?,?,?,?)")
        ->execute([(int)$agent['id'], $user_uid, $coins, 'failed', 'insufficient_funds']);
    json_out(['ok'=>false,'error'=>'insufficient_funds'], 402);
  }

  // idempotency (لو العمود موجود)
  if ($has_idk && $idk !== '') {
    $st = $pdo->prepare("SELECT id, balance_after FROM agent_ledger WHERE agent_id=? AND idempotency_key=? LIMIT 1");
    $st->execute([(int)$agent['id'], $idk]);
    if ($prev = $st->fetch()) {
      $pdo->rollBack();
      json_out([
        'ok'=>true,
        'idempotent'=>true,
        'charged'=>[
          'user_uid'=>$user_uid,
          'coins'=>$coins,
          'agent_balance_after'=>(int)$prev['balance_after'],
        ],
      ]);
    }
  }

  // خصم رصيد الوكيل
  $pdo->prepare("UPDATE agents SET main_balance = main_balance - ? WHERE id=? LIMIT 1")
      ->execute([$coins, (int)$agent['id']]);

  // رصيد بعد الخصم
  $st = $pdo->prepare("SELECT main_balance FROM agents WHERE id=? LIMIT 1");
  $st->execute([(int)$agent['id']]);
  $bal_after = (int)$st->fetchColumn();

  // إدراج دفتر حركات الوكيل — نبني الاستعلام حسب الأعمدة المتاحة
  $cols = ['agent_id','direction','reason','amount','balance_after'];
  $vals = [(int)$agent['id'], 'out', 'charge_user', $coins, $bal_after];
  if ($has_ref_uid) { $cols[] = 'ref_user_uid'; $vals[] = $user_uid; }
  if ($has_idk)     { $cols[] = 'idempotency_key'; $vals[] = $idk; }
  if ($has_currency){ $cols[] = 'currency'; $vals[] = 'coins'; }

  $ph = implode(',', array_fill(0, count($cols), '?'));
  $sql_ledger = "INSERT INTO agent_ledger (".implode(',', $cols).") VALUES ($ph)";
  $pdo->prepare($sql_ledger)->execute($vals);
  $ledger_id = (int)$pdo->lastInsertId();

  // إضافة الكوين للمستخدم
  $pdo->prepare("UPDATE users SET coins = coins + ? WHERE uid = ? LIMIT 1")
      ->execute([$coins, $user_uid]);

  // جلب رصيد المستخدم بعد العملية (اختياري)
  $st = $pdo->prepare("SELECT coins FROM users WHERE uid=? LIMIT 1");
  $st->execute([$user_uid]);
  $user_balance_after = (int)$st->fetchColumn();

  // سجل العملية الرئيسية
  $pdo->prepare("INSERT INTO agent_charges (agent_id,user_uid,coins,status,error_code,ledger_id) VALUES (?,?,?,?,?,?)")
      ->execute([(int)$agent['id'], $user_uid, $coins, 'success', null, $ledger_id]);

  $pdo->commit();

  json_out([
    'ok'=>true,
    'charged'=>[
      'user_uid'=>$user_uid,
      'coins'=>$coins,
      'agent_balance_after'=>$bal_after,
      'ledger_id'=>$ledger_id,
      'user_balance_after'=>$user_balance_after,
    ],
  ]);
} catch (Throwable $e) {
  if (isset($pdo) && $pdo instanceof PDO && $pdo->inTransaction()) { try{$pdo->rollBack();}catch(Throwable $e2){} }
  if ($DEBUG) json_out(['ok'=>false,'error'=>'server_error','message'=>$e->getMessage()], 500);
  json_out(['ok'=>false,'error'=>'server_error'], 500);
}
