<?php
// /public_html/voicechat/agents/auth_login.php
declare(strict_types=1);
require __DIR__ . '/_common.php';

// فعّل تتبّع الأخطاء مؤقتًا عند الحاجة: ?dbg=1
if (isset($_GET['dbg'])) { ini_set('display_errors','1'); error_reporting(E_ALL); }

try {
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    json_out(['ok'=>false,'error'=>'method_not_allowed'], 405);
  }

  $in       = json_in();
  $username = trim((string)($in['username'] ?? ''));
  $password = (string)($in['password'] ?? '');

  if ($username === '' || $password === '') {
    json_out(['ok'=>false,'error'=>'bad_credentials'], 400);
  }

  $pdo = db();
  $st = $pdo->prepare("SELECT * FROM agents WHERE username=? LIMIT 1");
  $st->execute([$username]);
  $agent = $st->fetch();

  if (!$agent)                        json_out(['ok'=>false,'error'=>'bad_credentials'], 401);
  if ($agent['status'] !== 'active')  json_out(['ok'=>false,'error'=>'agent_suspended'], 403);
  if (!password_verify($password, (string)$agent['password_hash'])) {
    json_out(['ok'=>false,'error'=>'bad_credentials'], 401);
  }

  $token   = agent_generate_token();
  $expires = date('Y-m-d H:i:s', time() + 12*3600);
  $ipbin   = ip_bin_or_null();

  $pdo->beginTransaction();
  $pdo->prepare("INSERT INTO agent_tokens (agent_id, token, expires_at) VALUES (?,?,?)")
      ->execute([(int)$agent['id'], $token, $expires]);

  // نخزن IP كثنائية مباشرة (عمودك VARBINARY(16))
  $pdo->prepare("UPDATE agents SET last_login_at=NOW(), last_login_ip=? WHERE id=? LIMIT 1")
      ->execute([$ipbin, (int)$agent['id']]);
  $pdo->commit();

  json_out([
    'ok'         => true,
    'token'      => $token,
    'expires_at' => $expires,
    'agent'      => [
      'id'           => (int)$agent['id'],
      'username'     => (string)$agent['username'],
      'display_name' => (string)$agent['display_name'],
      'status'       => (string)$agent['status'],
      'main_balance' => (int)$agent['main_balance'],
    ],
  ]);
} catch (Throwable $e) {
  if (isset($_GET['dbg'])) {
    json_out(['ok'=>false,'error'=>'exception','message'=>$e->getMessage()], 500);
  }
  json_out(['ok'=>false,'error'=>'server_error'], 500);
}
