<?php
// /public_html/voicechat/agents/web/convert.php
declare(strict_types=1);
require_once __DIR__ . '/_web_common.php';

$auth   = require_agent_or_redirect();
$token  = $auth['token'];
$agent  = $auth['agent'];

$msg = null; $err = null; $rate = null; $after = null;

// استعلام السعر/الأرصدة لعرضها
$r = api_call('convert_usd.php', 'GET', null, $token);
if (($r['ok'] ?? false)) {
  $rate = (float)$r['rate_coins_per_usd'];
} else {
  $err = ($r['error'] ?? 'rate_not_set') === 'rate_not_set' ? 'سعر التحويل غير مضبوط من الأدمن بعد.' : 'تعذّر جلب السعر.';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_ok($_POST['csrf'] ?? '')) {
    $err = 'رمز الأمان غير صالح.';
  } else {
    $usd = (float)($_POST['usd'] ?? 0);
    $res = api_call('convert_usd.php', 'POST', ['usd'=>$usd], $token);
    if (($res['ok'] ?? false)) {
      $msg   = 'تم تحويل $'.number_format((float)$res['converted']['usd'],2).' إلى '.(int)$res['converted']['coins'].' كوين.';
      $after = $res['balances_after'] ?? null;
      // حدّث بيانات الهيدر
      $p = api_call('profile.php','GET',null,$token);
      if (($p['ok'] ?? false)) $agent = $p['agent'];
      // حدّث السعر لو تغير
      if (isset($res['rate_coins_per_usd'])) $rate = (float)$res['rate_coins_per_usd'];
    } else {
      $map = [
        'bad_amount'      => 'المبلغ غير صالح.',
        'rate_not_set'    => 'سعر التحويل غير مضبوط من الأدمن.',
        'insufficient_usd'=> 'رصيد الدولار غير كافٍ.',
      ];
      $err = $map[$res['error'] ?? ''] ?? 'تعذّر التنفيذ.';
    }
  }
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1">
  <title>تحويل $ ➜ كوين</title>
  <style>
    :root{--bg:#0b1220;--panel:#0f172a;--text:#e5e7eb;--sub:#94a3b8;--border:#243047;--primary:#3b82f6;--danger:#ef4444;--ok:#22c55e}
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:var(--text);font-family:system-ui,-apple-system,Segoe UI,Roboto}
    .wrap{max-width:900px;margin:0 auto;padding:16px}
    .card{background:var(--panel);border:1px solid var(--border);border-radius:14px;padding:16px}
    h1{margin:0 0 12px}
    .grid{display:grid;gap:16px;grid-template-columns:1fr 1fr}
    @media (max-width:860px){.grid{grid-template-columns:1fr}}
    .input label{display:block;font-size:13px;color:var(--sub);margin-bottom:6px}
    .input input{width:100%;padding:12px;border-radius:12px;border:1px solid var(--border);background:#0c1426;color:var(--text);font-size:16px}
    .btn{display:inline-block;padding:10px 14px;border-radius:10px;border:1px solid var(--border);background:var(--primary);color:#fff;text-decoration:none;cursor:pointer}
    .alert{border:1px solid var(--danger);padding:10px 12px;border-radius:12px;background:rgba(239,68,68,.08);margin:10px 0}
    .ok{border-color:var(--ok)!important;background:rgba(34,197,94,.08)!important}
    .chips{display:flex;gap:8px;flex-wrap:wrap;margin-bottom:12px}
    .chip{display:inline-flex;align-items:center;gap:8px;border:1px solid #2b3753;background:linear-gradient(180deg,#0f1a33,#0d1529);padding:8px 12px;border-radius:999px;font-weight:700;white-space:nowrap}
    .mono{font-family:ui-monospace,Menlo,Consolas,monospace}
    .muted{color:var(--sub)}
  </style>
</head>
<body>
<?php require __DIR__ . '/_topnav.php'; ?>

<div class="wrap">

  <?php if ($err): ?><div class="alert"><?= e($err) ?></div><?php endif; ?>
  <?php if ($msg): ?><div class="alert ok"><?= e($msg) ?></div><?php endif; ?>

  <div class="chips">
    <div class="chip">💵 <span class="muted">USD:</span> <b class="mono"><?= number_format((float)($agent['usd_balance'] ?? 0),2) ?></b></div>
    <div class="chip">🪙 <span class="muted">Coins:</span> <b class="mono"><?= (int)($agent['main_balance'] ?? 0) ?></b></div>
    <?php if ($rate !== null): ?>
      <div class="chip">📈 <span class="muted">السعر:</span> <b class="mono"><?= rtrim(rtrim(number_format($rate, 6, '.', ''), '0'), '.') ?></b> كوين / $1</div>
    <?php endif; ?>
  </div>

  <div class="grid">
    <div class="card">
      <h1>تحويل دولار إلى كوين</h1>
      <form method="post" class="form" autocomplete="off">
        <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
        <div class="input">
          <label>المبلغ بالدولار ($)</label>
          <input type="number" name="usd" id="usd" min="0.01" step="0.01" required>
        </div>
        <div class="input">
          <label>سيتم إضافة (كوين)</label>
          <input type="text" id="coinsPreview" readonly>
        </div>
        <button class="btn" type="submit" <?= $rate===null?'disabled':''; ?>>تنفيذ التحويل</button>
        <?php if ($rate===null): ?><div class="muted" style="margin-top:8px">لا يمكن التحويل الآن لأن السعر غير مضبوط.</div><?php endif; ?>
      </form>
    </div>

    <div class="card">
      <h1>بعد العملية</h1>
      <?php if ($after): ?>
        <div class="muted">الأرصدة بعد آخر عملية ناجحة:</div>
        <div style="margin-top:8px">
          <div>💵 USD: <b class="mono"><?= number_format((float)$after['usd'],2) ?></b></div>
          <div>🪙 Coins: <b class="mono"><?= (int)$after['coins'] ?></b></div>
        </div>
      <?php else: ?>
        <div class="muted">لم يتم تنفيذ عملية في هذه الجلسة بعد.</div>
      <?php endif; ?>
    </div>
  </div>
</div>

<script>
(function(){
  const rate = <?= $rate!==null ? json_encode($rate) : 'null' ?>;
  const usd  = document.getElementById('usd');
  const out  = document.getElementById('coinsPreview');
  if (rate && usd && out) {
    function calc(){
      const u = parseFloat(usd.value || '0');
      const coins = Math.floor((u>0?u:0) * rate);
      out.value = coins.toString();
    }
    usd.addEventListener('input', calc);
  }
})();
</script>
</body>
</html>
