# Backend (PHP) Quick Start

1) Create MySQL DB `chatvoice`, then import `sql/schema.sql`.
2) Edit `api/config.php` with DB credentials, JWT secret, and Agora App ID.
3) Deploy `backend/api` to your server (e.g., `https://yourdomain.com/api/`).

Endpoints (JSON):
- POST `/api/auth_register.php` {email, username, password}
- POST `/api/auth_login.php` {email, password}
- GET  `/api/rooms_list.php`
- POST `/api/room_create.php`  (Auth: Bearer) {name, image_url?, max_seats?}
- POST `/api/room_join_leave.php` (Auth: Bearer) {room_uid, action: "join"|"leave"}
- POST `/api/agora_token.php` (Auth: Bearer) {room_uid}

**Note about room UID == owner UID**: as requested, each room uses the creator's UID as the room UID and Agora channel name. That means one active room per user. You can change later to a generated UUID if you want multiple rooms per user.


---

## Production Notes (battle-party.com)
- مسار التثبيت المقترح: `https://battle-party.com/voicechat/api/`
- مجلد الرفع: `https://battle-party.com/voicechat/uploads/`
- تأكد من صلاحيات الكتابة على `backend/uploads/` وما داخلها (0755 أو بحسب شركة الاستضافة).
- رفع ملف `.htaccess` المرفق داخل `uploads/` لحظر تنفيذ أي سكربتات.
- **بيانات قاعدة البيانات** مضبوطة داخل `api/config.php` كما زوّدتني بها.
- ضع **Agora App ID** في `config.php` (`$AGORA_APP_ID`).

### Endpoint جديد لرفع الملفات
- `POST /api/upload.php` (مطلوب Authorization Bearer)
- حقل multipart: `file`
- صيغ مدعومة: jpg, png, webp, gif, mp3, mp4, pdf, txt
- حد الحجم: 25MB
- الاستجابة: `{ ok: true, url: "https://battle-party.com/voicechat/uploads/YYYY/MM/xxxx.ext" }`
